/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.xml;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.CumulativeWorkplaceActivity;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.property.Propertized;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.CumulativeAction;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.shop.RebuildType;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.store.ExternalStoreActivity;
import cz.insophy.inplan.store.InPlanStoreActivity;
import cz.insophy.inplan.store.MaterialRequest;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.store.TransactionStoreActivity;
import cz.insophy.inplan.store.TransactionStoreActivityTarget;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.StartEndQtyUpdater;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Identifiable;
import cz.insophy.inplan.util.Sorted;
import cz.insophy.inplan.util.problems.Problem;
import cz.insophy.inplan.xml.ConversionException;
import cz.insophy.inplan.xml.InvalidXmlException;
import cz.insophy.inplan.xml.RobustSuperplanLoadResult;
import cz.insophy.inplan.xml.ShopSerializationException;
import cz.insophy.inplan.xml.ShopSerializer;
import cz.insophy.inplan.xml.SuperplanSerializationException;
import cz.insophy.inplan.xml.SuperplanVersionSupport;
import cz.insophy.inplan.xml.XmlSource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidationSchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuperplanSerializer {
    public static final String ZIP_CONF_FN = "conf.xml";
    public static final String ZIP_PLAN_FN = "plan.xml";
    private static final XMLValidationSchema superplanSchema;
    private static final Logger log;
    private static final String XML_ENCODING = "utf-8";
    public static final String GLOBAL_GROUP_IDENTIFIER = "GLOBAL_GROUP";
    public static final String WORKPLACE_NAME_VALUE_SEPARATOR = ":";
    public static final String NAME_POSITION_SEPARATOR = "#";
    public static final String WORKPLACES_SEPARATOR = ";";

    public static void storeToXml(Superplan superplan, OutputStream os) throws SuperplanSerializationException {
        new SuperplanWriter(superplan, os, false).write();
    }

    public static void storeToXml(Superplan superplan, OutputStream os, boolean sorted) throws SuperplanSerializationException {
        new SuperplanWriter(superplan, os, sorted).write();
    }

    public static void storeToXml(Superplan superplan, Writer writer) throws SuperplanSerializationException {
        new SuperplanWriter(superplan, writer).write();
    }

    public static void storeToXml(Superplan superplan, File file) throws SuperplanSerializationException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            new SuperplanWriter(superplan, fos, false).write();
        }
        catch (Exception e) {
            throw new SuperplanSerializationException(e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static byte[] storeToXmlBytes(Superplan superplan) throws SuperplanSerializationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SuperplanSerializer.storeToXml(superplan, baos);
        return baos.toByteArray();
    }

    public static Superplan loadFromXml(XmlSource source, ShopConfiguration shopConf, boolean forceConversion) throws SuperplanSerializationException {
        source = SuperplanSerializer.convertToLatest(source, forceConversion);
        SuperplanReader r = new SuperplanReader(source, shopConf, ReaderErrorMode.STRICT);
        r.read();
        source.closeSource();
        return r.getSuperplan();
    }

    public static RobustSuperplanLoadResult robustLoadFromXml(XmlSource source, ShopConfiguration shopConf, boolean forceConversion) throws SuperplanSerializationException {
        source = SuperplanSerializer.convertToLatest(source, forceConversion);
        SuperplanReader r = new SuperplanReader(source, shopConf, ReaderErrorMode.DELETE_UNKNOWN);
        r.read();
        source.closeSource();
        return new RobustSuperplanLoadResult(r.getSuperplan(), r.getErrors());
    }

    private static XmlSource convertToLatest(XmlSource source, boolean forceConversion) throws SuperplanSerializationException {
        block4: {
            try {
                int versionComparison = SuperplanVersionSupport.isCompareWithCurrentVersion(source);
                if (versionComparison > 0) {
                    throw new SuperplanSerializationException("Newer superplan version passed - cannot be loaded.");
                }
                if (versionComparison >= 0) break block4;
                if (forceConversion) {
                    source = SuperplanVersionSupport.convertToCurrent(source);
                    break block4;
                }
                throw new SuperplanSerializationException("Old superplan version passed and conversion is not active");
            }
            catch (ConversionException | InvalidXmlException | XMLStreamException e) {
                throw new SuperplanSerializationException(e);
            }
        }
        return source;
    }

    public static Superplan loadFromZip(File zipFile) throws IOException, SuperplanSerializationException, InvalidXmlException {
        try (ZipFile zf = new ZipFile(zipFile);){
            Superplan superplan;
            block18: {
                ShopConfiguration conf;
                ZipEntry confEntry = zf.getEntry(ZIP_CONF_FN);
                Preconditions.checkState(confEntry != null, "Zip %s does not contain %s", (Object)zipFile, (Object)ZIP_CONF_FN);
                ZipEntry planEntry = zf.getEntry(ZIP_PLAN_FN);
                Preconditions.checkState(planEntry != null, "Zip %s does not contain %s", (Object)zipFile, (Object)ZIP_PLAN_FN);
                try (InputStream confIs = zf.getInputStream(confEntry);){
                    conf = ShopSerializer.loadFromXml(confIs);
                }
                InputStream planIs = zf.getInputStream(planEntry);
                try {
                    superplan = SuperplanSerializer.loadFromXml(XmlSource.create(planIs), conf, true);
                    if (planIs == null) break block18;
                }
                catch (Throwable throwable) {
                    if (planIs != null) {
                        try {
                            planIs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                planIs.close();
            }
            return superplan;
        }
    }

    public static Superplan loadFromZip(InputStream zipStream) throws IOException, SuperplanSerializationException, InvalidXmlException {
        File tempFile = File.createTempFile("plan", ".zip");
        try {
            Files.asByteSink(tempFile, new FileWriteMode[0]).writeFrom(zipStream);
            Superplan superplan = SuperplanSerializer.loadFromZip(tempFile);
            return superplan;
        }
        finally {
            if (!tempFile.delete()) {
                log.warn("Cannot delete temporary file {}", (Object)tempFile);
            }
        }
    }

    public static void storeToZip(Superplan superplan, OutputStream zipStream) throws IOException, ShopSerializationException, SuperplanSerializationException {
        ZipOutputStream zs = new ZipOutputStream(zipStream);
        zs.putNextEntry(new ZipEntry(ZIP_CONF_FN));
        ShopSerializer.storeToXml(superplan.getShopConf(), zs);
        zs.putNextEntry(new ZipEntry(ZIP_PLAN_FN));
        SuperplanSerializer.storeToXml(superplan, zs);
        zs.finish();
    }

    public static void storeToZip(Superplan superplan, File zipFile) throws IOException, ShopSerializationException, SuperplanSerializationException {
        try (OutputStream os = Files.asByteSink(zipFile, new FileWriteMode[0]).openBufferedStream();){
            SuperplanSerializer.storeToZip(superplan, os);
        }
    }

    static {
        log = LoggerFactory.getLogger(SuperplanSerializer.class);
        XMLValidationSchemaFactory vsf = XMLValidationSchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            superplanSchema = vsf.createSchema(SuperplanSerializer.class.getResource("plan.xsd"));
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
    }

    private static final class SuperplanWriter {
        private final Superplan superplan;
        private final ShopConfiguration conf;
        private final XMLStreamWriter xw;
        private final Map<ActionActivity, Integer> aaIdMap;
        private final boolean sort;
        private int latestId;
        private static final String PLAN_NS_URI = "http://www.insophy.cz/inplan/plan/5.x";
        private static final String XSD_NS_URI = "http://www.w3.org/2001/XMLSchema-instance";

        public SuperplanWriter(Superplan superplan, OutputStream ostream, boolean sorted) throws SuperplanSerializationException {
            if (superplan == null) {
                throw new IllegalArgumentException("Superplan must not be null.");
            }
            this.superplan = superplan;
            this.conf = superplan.getShopConf();
            this.aaIdMap = new IdentityHashMap<ActionActivity, Integer>();
            this.latestId = 0;
            this.sort = sorted;
            try {
                XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
                this.xw = xmlOutputFactory.createXMLStreamWriter(ostream, SuperplanSerializer.XML_ENCODING);
            }
            catch (XMLStreamException e) {
                throw new SuperplanSerializationException(e);
            }
            catch (FactoryConfigurationError e) {
                throw new SuperplanSerializationException(e);
            }
        }

        public SuperplanWriter(Superplan superplan, Writer writer) throws SuperplanSerializationException {
            if (superplan == null) {
                throw new IllegalArgumentException("Superplan must not be null.");
            }
            this.superplan = superplan;
            this.conf = superplan.getShopConf();
            this.aaIdMap = new IdentityHashMap<ActionActivity, Integer>();
            this.latestId = 0;
            this.sort = false;
            try {
                XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
                this.xw = xmlOutputFactory.createXMLStreamWriter(writer);
            }
            catch (XMLStreamException e) {
                throw new SuperplanSerializationException(e);
            }
            catch (FactoryConfigurationError e) {
                throw new SuperplanSerializationException(e);
            }
        }

        private int addToIdMap(ActionActivity aa) {
            this.aaIdMap.put(aa, this.latestId);
            return this.latestId++;
        }

        public void write() throws SuperplanSerializationException {
            try {
                this.xw.writeStartDocument();
                this.xw.setDefaultNamespace(PLAN_NS_URI);
                this.xw.writeStartElement("plan");
                this.xw.writeDefaultNamespace(PLAN_NS_URI);
                this.xw.writeNamespace("xsi", XSD_NS_URI);
                this.xw.writeAttribute(XSD_NS_URI, "schemaLocation", "http://www.insophy.cz/inplan/plan/5.x plan.xsd ");
                this.xw.writeAttribute("schemaVersion", "5.0");
                this.xw.writeAttribute("revision", "" + this.superplan.getRevision());
                this.writeWorkplaceSchedules();
                this.writeStoreSchedule();
                this.writeProductionTree();
                this.writeMaterialRequests();
                this.xw.writeEndElement();
                this.xw.writeEndDocument();
                this.xw.close();
            }
            catch (XMLStreamException e) {
                throw new SuperplanSerializationException(e);
            }
        }

        private void writeWorkplaceSchedules() throws XMLStreamException {
            for (Workplace wp : this.conf.getWorkplaces()) {
                WorkplaceSchedule wpSched = this.superplan.getPlan().getWorkplaceSchedule(wp);
                this.xw.writeCharacters("\n");
                this.xw.writeStartElement("workplace-schedule");
                this.xw.writeAttribute("workplace", wp.getName());
                for (WorkplaceActivity wa : wpSched.activities()) {
                    this.writeWorkplaceActivity(wa);
                }
                this.xw.writeEndElement();
            }
        }

        private void writeWorkplaceActivity(WorkplaceActivity wa) throws XMLStreamException {
            this.xw.writeCharacters("\n");
            if (wa instanceof ActionActivity) {
                ActionActivity aa = (ActionActivity)wa;
                int aid = this.addToIdMap(aa);
                this.xw.writeStartElement("action");
                this.xw.writeAttribute("aid", Integer.toString(aid));
                this.xw.writeAttribute("start", Long.toString(wa.getStart()));
                this.xw.writeAttribute("end", Long.toString(wa.getEnd()));
                this.xw.writeAttribute("q", Double.toString(aa.getQty()));
                this.xw.writeEndElement();
            } else if (wa instanceof RebuildActivity) {
                RebuildActivity ra = (RebuildActivity)wa;
                this.xw.writeEmptyElement("rebuild");
                this.xw.writeAttribute("start", Long.toString(wa.getStart()));
                this.xw.writeAttribute("end", Long.toString(wa.getEnd()));
                if (ra.getTo() != null) {
                    this.xw.writeAttribute("to", ra.getTo());
                }
            } else if (wa instanceof OfflineActivity) {
                OfflineActivity oa = (OfflineActivity)wa;
                this.xw.writeEmptyElement("offline");
                this.xw.writeAttribute("start", Long.toString(wa.getStart()));
                this.xw.writeAttribute("end", Long.toString(wa.getEnd()));
                if (oa.hasNote()) {
                    this.xw.writeAttribute("note", oa.getNote());
                }
            } else if (wa instanceof CumulativeWorkplaceActivity) {
                CumulativeWorkplaceActivity cwa = (CumulativeWorkplaceActivity)wa;
                for (ActionActivity wa2 : cwa.getActionActivities()) {
                    this.writeWorkplaceActivity(wa2);
                }
            } else {
                throw new IllegalStateException("Unknown workplace activity type " + wa.getClass().getSimpleName());
            }
        }

        private void writeStoreSchedule() throws XMLStreamException {
            this.xw.writeCharacters("\n");
            this.xw.writeStartElement("store-schedule");
            Long stockInitDate = this.superplan.getStockInitDate();
            this.xw.writeAttribute("stock-init-date", stockInitDate.toString());
            for (StoreType type : StoreType.values()) {
                StoreSchedule ss = this.superplan.getPlan().getStoreSchedule(type);
                if (type.isView()) continue;
                for (Material mp : this.conf.getMatprods()) {
                    this.writeStoreScheduleActivities(ss.getActivities(mp));
                }
            }
            this.xw.writeEndElement();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void writeStoreScheduleActivities(Iterable<StoreActivity> activities) throws XMLStreamException {
            for (StoreActivity sa : activities) {
                String type;
                String targetId = null;
                String targetType = null;
                if (sa instanceof TransactionStoreActivity) {
                    type = "transaction-activity";
                    TransactionStoreActivity trSa = (TransactionStoreActivity)sa;
                    TransactionStoreActivityTarget target = trSa.getTarget();
                    Preconditions.checkNotNull(target, "Transaction activity target cannot be null.");
                    if (target instanceof GeneralizedOrderRequest) {
                        targetId = ((GeneralizedOrderRequest)target).getId();
                        targetType = null;
                    } else if (target instanceof CustomerRequest) {
                        targetId = ((CustomerRequest)target).getId();
                        targetType = "cr";
                    } else {
                        if (!(target instanceof SupplyRequest)) throw new IllegalStateException("Unknown transaction activity target type " + target.getClass().getSimpleName());
                        targetId = ((SupplyRequest)target).getId();
                        targetType = "sr";
                    }
                } else if (sa instanceof ExternalStoreActivity) {
                    type = "external-activity";
                } else {
                    if (sa instanceof InPlanStoreActivity) continue;
                    throw new IllegalStateException("Unknown store activity type " + sa.getClass().getSimpleName());
                }
                this.xw.writeCharacters("\n");
                this.xw.writeEmptyElement(type);
                this.xw.writeAttribute("material", sa.getMaterial().getName());
                if (sa instanceof ExternalStoreActivity) {
                    ExternalStoreActivity esa = (ExternalStoreActivity)sa;
                    this.xw.writeAttribute("time", "" + (esa.getTime() - esa.getTimeOffset()));
                    this.xw.writeAttribute("q", "" + (esa.getQty() - esa.getQtyOffset()));
                    if (esa.getQtyOffset() != 0.0) {
                        this.xw.writeAttribute("q-off", "" + esa.getQtyOffset());
                    }
                    if (esa.getTimeOffset() != 0L) {
                        this.xw.writeAttribute("time-off", "" + esa.getTimeOffset());
                    }
                    if (!Strings.isNullOrEmpty(esa.getDescription())) {
                        this.xw.writeAttribute("description", esa.getDescription());
                    }
                    if (esa.getType() != ExternalStoreActivity.Type.STANDARD) {
                        this.xw.writeAttribute("type", esa.getType().name());
                    }
                } else {
                    this.xw.writeAttribute("time", "" + sa.getTime());
                    this.xw.writeAttribute("q", "" + sa.getQty());
                }
                if (targetId == null) continue;
                this.xw.writeAttribute("target", targetId);
                if (targetType == null) continue;
                this.xw.writeAttribute("target-type", targetType);
            }
        }

        private void writeProductionTree() throws XMLStreamException {
            this.xw.writeCharacters("\n");
            this.xw.writeStartElement("production-tree");
            Long fixationDate = this.superplan.getFixationDate();
            this.xw.writeAttribute("fixation-date", fixationDate.toString());
            for (GeneralizedOrderRequest gor : this.optionallySortedById(this.superplan.getGors())) {
                this.writeGor(gor);
            }
            this.xw.writeEndElement();
        }

        private void writeGor(GeneralizedOrderRequest gor) throws XMLStreamException {
            this.xw.writeCharacters("\n");
            this.xw.writeStartElement("gor");
            this.xw.writeAttribute("gid", gor.getId());
            this.xw.writeAttribute("product", gor.getProduct().getName());
            this.xw.writeAttribute("priority", Integer.toString(gor.getPriority()));
            this.xw.writeAttribute("selected", Boolean.toString(gor.isUserSelected()));
            this.writeReleaseDue(gor);
            this.xw.writeAttribute("qty", Double.toString(gor.getRequestedQty()));
            if (gor.getCompletedQty() > 0.0) {
                this.xw.writeAttribute("completed-qty", Double.toString(gor.getCompletedQty()));
            }
            if (gor.getOutOfPlanQty() > 0.0) {
                this.xw.writeAttribute("out-of-plan-qty", Double.toString(gor.getOutOfPlanQty()));
            }
            this.xw.writeAttribute("state", gor.getState().toString());
            String description = gor.getDescription();
            if (description != null && !description.trim().equals("")) {
                this.xw.writeAttribute("description", description);
            }
            if (gor.hasSelectedActiongram()) {
                this.xw.writeAttribute("actiongram", gor.getSelectedActiongram().getName());
            }
            if (gor.isActiongramLocked()) {
                this.xw.writeAttribute("actiongram-locked", Boolean.toString(gor.isActiongramLocked()));
            }
            this.writeProperties(gor);
            for (GeneralizedActionRequest gar : gor.getGars()) {
                this.writeGar(gar);
            }
            this.xw.writeEndElement();
        }

        private void writeGar(GeneralizedActionRequest gar) throws XMLStreamException {
            String description;
            this.xw.writeCharacters("\n");
            this.xw.writeStartElement("gar");
            Action action = gar.getAction();
            this.xw.writeAttribute("action", action.getName());
            if (!action.getLocalAltName().equals(action.getMainLocalAlt().getLocalAltName())) {
                this.xw.writeAttribute("local-alt", action.getLocalAltName());
            }
            if (gar.isActionLocked()) {
                this.xw.writeAttribute("la-locked", Boolean.toString(gar.isActionLocked()));
            }
            this.writeReleaseDue(gar);
            this.xw.writeAttribute("qty", Double.toString(gar.getRequestedQty()));
            if (gar.getCompletedQty() > 0.0) {
                this.xw.writeAttribute("completed-qty", Double.toString(gar.getCompletedQty()));
            }
            if (gar.getOutOfPlanQty() > 0.0) {
                this.xw.writeAttribute("out-of-plan-qty", Double.toString(gar.getOutOfPlanQty()));
            }
            if (gar.getOutOfPlanMat() > 0.0) {
                this.xw.writeAttribute("out-of-plan-mat", Double.toString(gar.getOutOfPlanMat()));
            }
            if ((description = gar.getDescription()) != null && !description.trim().equals("")) {
                this.xw.writeAttribute("description", description);
            }
            if (gar.isBlocked()) {
                this.xw.writeAttribute("blocked", "" + gar.isBlocked());
            }
            if (GeneralizedRequest.isDateValid(gar.getLatestPossibleStart())) {
                this.xw.writeAttribute("latest-possible-start", Long.toString(gar.getLatestPossibleStart()));
            }
            this.writeProperties(gar);
            if (!gar.getActivities().isEmpty()) {
                this.xw.writeStartElement("activities");
                for (ActionActivity aa : gar.getActivities()) {
                    this.xw.writeEmptyElement("aa");
                    Integer aid = this.aaIdMap.get(aa);
                    if (aid == null) {
                        throw new IllegalStateException("Internal error. Action activity from the production tree is not in the plan.");
                    }
                    this.xw.writeAttribute("aref", aid.toString());
                }
                this.xw.writeEndElement();
            }
            this.xw.writeEndElement();
        }

        private void writeReleaseDue(GeneralizedRequest r) throws XMLStreamException {
            this.xw.writeAttribute("release", Long.toString(r.getReleaseDate()));
            this.xw.writeAttribute("due", Long.toString(r.getDueDate()));
        }

        private void writeMaterialRequests() throws XMLStreamException {
            List<CustomerRequest> customerRequests = this.superplan.getCustomerRequests();
            List<SupplyRequest> supplyRequests = this.superplan.getSupplyRequests();
            if (!customerRequests.isEmpty()) {
                this.xw.writeStartElement("customer-requests");
                for (CustomerRequest creq : this.optionallySortedById(customerRequests)) {
                    this.writeMaterialRequest(creq, "priority", "" + creq.getPriority(), "state", creq.getState().name());
                }
                this.xw.writeEndElement();
            }
            if (!supplyRequests.isEmpty()) {
                this.xw.writeStartElement("supply-requests");
                for (SupplyRequest sreq : this.optionallySortedById(supplyRequests)) {
                    this.writeMaterialRequest(sreq, "state", sreq.getState().name());
                }
                this.xw.writeEndElement();
            }
        }

        private void writeMaterialRequest(MaterialRequest mreq, String ... attributes) throws XMLStreamException {
            Preconditions.checkArgument(attributes.length % 2 == 0);
            boolean hasProperties = mreq.getProperties().size() > 0;
            this.xw.writeCharacters("\n");
            if (hasProperties) {
                this.xw.writeStartElement("request");
            } else {
                this.xw.writeEmptyElement("request");
            }
            this.xw.writeAttribute("material", mreq.getMaterial().getName());
            this.xw.writeAttribute("rid", mreq.getId());
            this.xw.writeAttribute("due", "" + mreq.getTime());
            this.xw.writeAttribute("qty", "" + mreq.getQty());
            this.xw.writeAttribute("qty-offset", "" + mreq.getQtyOffset());
            this.xw.writeAttribute("time-offset", "" + mreq.getTimeOffset());
            for (int i = 0; i < attributes.length; i += 2) {
                this.xw.writeAttribute(attributes[i], attributes[i + 1]);
            }
            if (hasProperties) {
                this.writeProperties(mreq);
                this.xw.writeEndElement();
            }
        }

        private void writeProperties(Propertized p) throws XMLStreamException {
            if (p.getProperties().size() > 0) {
                this.xw.writeCharacters("\n");
                this.xw.writeStartElement("properties");
                for (Map.Entry<PropertyDefinition, Object> prop : p.getProperties().entrySet()) {
                    PropertyDefinition pd = prop.getKey();
                    Object value = prop.getValue();
                    this.xw.writeCharacters("\n ");
                    this.xw.writeEmptyElement("property");
                    this.xw.writeAttribute("name", pd.getName());
                    this.xw.writeAttribute("value", pd.getType().asString(value));
                }
                this.xw.writeEndElement();
            }
        }

        private <T extends Identifiable> List<T> optionallySortedById(List<T> objs) {
            return this.sort ? Sorted.byId(objs) : objs;
        }
    }

    private static final class SuperplanReader {
        private static final Logger log = LoggerFactory.getLogger(SuperplanReader.class);
        private final Superplan superplan;
        private final XMLStreamReader xr;
        private final ShopConfiguration config;
        private final Map<Integer, ActionActivity> aaMap;
        private final Multimap<TrsaTarget, TransactionStoreActivity> transactionMap;
        private final List<Problem> errors;
        private final ReaderErrorMode mode;
        private Map<String, String> attributes = new HashMap<String, String>(10);
        private Map<String, Material> matprodLut;

        public SuperplanReader(XmlSource source, ShopConfiguration shopConf, ReaderErrorMode mode) throws SuperplanSerializationException {
            this.superplan = new Superplan(shopConf);
            this.config = shopConf;
            this.aaMap = Maps.newHashMap();
            this.transactionMap = HashMultimap.create();
            this.errors = Lists.newArrayList();
            this.mode = mode;
            this.matprodLut = Maps.newHashMap();
            for (Material m3 : this.config.getMatprods()) {
                this.matprodLut.put(m3.getName(), m3);
            }
            try {
                System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
                XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
                this.xr = source.getReader(xmlInputFactory);
                ((XMLStreamReader2)this.xr).validateAgainst(superplanSchema);
            }
            catch (XMLStreamException e) {
                throw new SuperplanSerializationException(e);
            }
            catch (FactoryConfigurationError e) {
                throw new SuperplanSerializationException(e);
            }
        }

        public List<Problem> getErrors() {
            return this.errors;
        }

        public Superplan getSuperplan() {
            return this.superplan;
        }

        public void read() throws SuperplanSerializationException {
            try {
                this.xr.nextTag();
                this.checkStartTag("plan");
                this.parseAttributes();
                int revision = 0;
                if (this.hasAttribute("revision")) {
                    revision = this.getIntAttribute("revision");
                }
                this.superplan.setRevision(revision);
                this.xr.nextTag();
                this.readWorkplaceSchedules();
                this.readStoreSchedule();
                if (this.xr.isStartElement() && this.xr.getLocalName().equals("production-tree")) {
                    this.readProductionTree();
                }
                this.readMaterialRequests();
                this.pairTransactionActivities();
                this.checkEndTag("plan");
                this.xr.close();
            }
            catch (XMLStreamException e) {
                throw new SuperplanSerializationException(e);
            }
        }

        private void pairTransactionActivities() throws SuperplanSerializationException {
            for (Map.Entry<TrsaTarget, Collection<TransactionStoreActivity>> entry : this.transactionMap.asMap().entrySet()) {
                TrsaTarget tgt = entry.getKey();
                TransactionStoreActivityTarget target = tgt.findTargetIn(this.superplan);
                Collection<TransactionStoreActivity> sas = entry.getValue();
                if (target != null) {
                    for (TransactionStoreActivity sa : sas) {
                        sa.setTarget(target);
                    }
                    continue;
                }
                this.reportError("02920", new Object[]{tgt.type, tgt.id});
                for (TransactionStoreActivity sa : sas) {
                    this.superplan.getPlan().removeActivity(sa);
                }
            }
            this.transactionMap.clear();
        }

        private void readWorkplaceSchedules() throws XMLStreamException, SuperplanSerializationException {
            while (this.xr.isStartElement() && this.xr.getLocalName().equals("workplace-schedule")) {
                this.parseAttributes();
                String wpName = this.getStringAttribute("workplace");
                Workplace workplace = this.config.getWorkplace(wpName);
                if (workplace != null) {
                    this.xr.nextTag();
                    while (this.xr.isStartElement()) {
                        WorkplaceActivity wpa = this.readWorkplaceActivity(workplace);
                        if (wpa == null) continue;
                        this.addActivityToPlan(wpa);
                    }
                } else {
                    this.reportError("02985", wpName);
                    this.skipUntilEndTag();
                }
                this.skipEndTag("workplace-schedule");
            }
        }

        private void reportError(String errorCode, Object ... args) throws SuperplanSerializationException {
            Problem prob = Problem.createProblem2(errorCode, args);
            String message = prob.getMessage();
            if (this.mode != ReaderErrorMode.DELETE_UNKNOWN) {
                if (this.mode == ReaderErrorMode.STRICT) {
                    throw new SuperplanSerializationException(message);
                }
                throw new IllegalStateException();
            }
            this.errors.add(prob);
        }

        private WorkplaceActivity readWorkplaceActivity(Workplace workplace) throws XMLStreamException, SuperplanSerializationException {
            WorkplaceActivity wpa;
            String tagName = this.xr.getLocalName();
            this.parseAttributes();
            long start = this.getLongAttribute("start");
            long end = this.getLongAttribute("end");
            if (start >= end) {
                this.reportError("02991", workplace.getName());
                this.skipUntilEndTag();
                this.xr.nextTag();
                return null;
            }
            if (tagName.equals("action")) {
                int aid = this.getIntAttribute("aid");
                double q = this.getDoubleAttribute("q");
                ActionActivity aa = new ActionActivity(start, end, workplace, null, q);
                this.aaMap.put(aid, aa);
                wpa = null;
                this.xr.nextTag();
                this.skipEndTag("action");
            } else if (tagName.equals("rebuild")) {
                RebuildActivity ra;
                wpa = ra = new RebuildActivity(start, end, workplace);
                if (this.hasAttribute("to")) {
                    String toS = this.getStringAttribute("to");
                    RebuildType to = workplace.getRebuildType(toS);
                    ra.setTo(to);
                    if (to == null) {
                        this.reportError("02990", toS);
                        wpa = null;
                    }
                }
                this.xr.nextTag();
                this.skipEndTag("rebuild");
            } else if (tagName.equals("offline")) {
                OfflineActivity oa = new OfflineActivity(start, end, workplace);
                wpa = oa;
                if (this.hasAttribute("note")) {
                    oa.setNote(this.getStringAttribute("note"));
                }
                this.xr.nextTag();
                this.skipEndTag("offline");
            } else {
                throw new SuperplanSerializationException("Unexpected tag " + tagName + " on line " + this.xr.getLocation().getLineNumber());
            }
            return wpa;
        }

        private void readStoreSchedule() throws XMLStreamException, SuperplanSerializationException {
            this.checkStartTag("store-schedule");
            this.parseAttributes();
            long stockInitDate = -9223372036854775708L;
            if (this.hasAttribute("stock-init-date")) {
                stockInitDate = this.getLongAttribute("stock-init-date");
            }
            this.superplan.setStockInitDate(stockInitDate);
            this.xr.nextTag();
            while (this.xr.isStartElement()) {
                StoreActivity storeActivity = this.readStoreActivity();
                if (storeActivity == null) continue;
                this.superplan.getPlan().addActivity(storeActivity);
            }
            this.skipEndTag("store-schedule");
        }

        private StoreActivity readStoreActivity() throws SuperplanSerializationException, XMLStreamException {
            StoreActivity sa;
            String tagName = this.xr.getLocalName();
            this.parseAttributes();
            this.xr.nextTag();
            this.skipEndTag(tagName);
            String matName = this.getStringAttribute("material");
            Material m3 = this.config.getMatprod(matName);
            if (m3 == null) {
                this.reportError("02970", matName);
                sa = null;
            } else {
                long time = this.getLongAttribute("time");
                double qty = this.getDoubleAttribute("q");
                long time_off = 0L;
                double qty_off = 0.0;
                String type = "";
                String description = "";
                if (this.hasAttribute("time-off")) {
                    time_off = this.getLongAttribute("time-off");
                }
                if (this.hasAttribute("q-off")) {
                    qty_off = this.getDoubleAttribute("q-off");
                }
                if (this.hasAttribute("type")) {
                    type = this.getStringAttribute("type");
                }
                if (this.hasAttribute("description")) {
                    description = this.getStringAttribute("description");
                }
                if (tagName.equals("transaction-activity")) {
                    String targetId = this.getStringAttribute("target");
                    String targetType = this.hasAttribute("target-type") ? this.getStringAttribute("target-type") : "gor";
                    TrsaTarget tgt = new TrsaTarget(targetType, targetId);
                    TransactionStoreActivity trSa = new TransactionStoreActivity(time, m3, qty, null);
                    this.transactionMap.put(tgt, trSa);
                    sa = trSa;
                } else if (tagName.equals("external-activity")) {
                    sa = new ExternalStoreActivity(time, m3, qty);
                    ((ExternalStoreActivity)sa).setTimeOffset(time_off);
                    ((ExternalStoreActivity)sa).setQtyOffset(qty_off);
                    ((ExternalStoreActivity)sa).setDescription(description);
                    for (ExternalStoreActivity.Type t : ExternalStoreActivity.Type.values()) {
                        if (!t.name().equals(type)) continue;
                        ((ExternalStoreActivity)sa).setType(t);
                    }
                } else {
                    throw new SuperplanSerializationException("Unkown material type " + tagName + " found in plan xml.");
                }
            }
            return sa;
        }

        private void readProductionTree() throws XMLStreamException, SuperplanSerializationException {
            this.checkStartTag("production-tree");
            this.parseAttributes();
            long fixationDate = -9223372036854775708L;
            if (this.hasAttribute("fixation-date")) {
                fixationDate = this.getLongAttribute("fixation-date");
            }
            this.superplan.setFixationDate(fixationDate);
            this.xr.nextTag();
            while (this.xr.isStartElement()) {
                GeneralizedOrderRequest gor = this.readGor();
                if (gor == null) continue;
                this.superplan.unsafeAddGor(gor);
            }
            this.skipEndTag("production-tree");
            StartEndQtyUpdater.updateFrom(this.superplan);
        }

        private GeneralizedOrderRequest readGor() throws XMLStreamException, SuperplanSerializationException {
            GeneralizedOrderRequest gor;
            Product product;
            this.checkStartTag("gor");
            this.parseAttributes();
            long release = this.getLongAttribute("release");
            long due = this.getLongAttribute("due");
            double qty = this.getDoubleAttribute("qty");
            GeneralizedOrderRequest.State state = this.hasAttribute("state") ? GeneralizedOrderRequest.State.valueOf(this.getStringAttribute("state")) : GeneralizedOrderRequest.State.RELEASED;
            double completedQty = 0.0;
            if (this.hasAttribute("completed-qty")) {
                completedQty = this.getDoubleAttribute("completed-qty");
            }
            double outOfPlanQty = 0.0;
            if (this.hasAttribute("out-of-plan-qty")) {
                outOfPlanQty = this.getDoubleAttribute("out-of-plan-qty");
            }
            String description = null;
            if (this.hasAttribute("description")) {
                description = this.getStringAttribute("description");
            }
            int priority = this.getIntAttribute("priority");
            String gid = this.getStringAttribute("gid");
            boolean isSelected = this.getBooleanAttribute("selected");
            String productName = this.getStringAttribute("product");
            String actiongramName = null;
            if (this.hasAttribute("actiongram")) {
                actiongramName = this.getStringAttribute("actiongram");
            }
            boolean isActiongramLocked = false;
            if (this.hasAttribute("actiongram-locked")) {
                isActiongramLocked = this.getBooleanAttribute("actiongram-locked");
            }
            if ((product = this.config.getProduct(productName)) == null) {
                this.reportError("02940", productName, gid);
                if (this.xr.isStartElement()) {
                    this.skipUntilEndTag();
                }
                gor = null;
            } else {
                gor = new GeneralizedOrderRequest(gid, product, qty, release, due, state);
                gor.setPriority(priority);
                gor.setUserSelected(isSelected);
                gor.unsafeSetOutOfPlanQty(outOfPlanQty);
                gor.setCompletedQty(completedQty);
                if (description != null) {
                    gor.setDescription(description);
                }
                this.xr.nextTag();
                if (this.xr.isStartElement() && this.xr.getLocalName().equals("properties")) {
                    gor.setProperties(this.readProperties(GeneralizedOrderRequest.class), this.config.getPropertyDefinitionsInfoFor(GeneralizedOrderRequest.class));
                }
                if (actiongramName != null) {
                    Actiongram actiongram = product.getActiongram(actiongramName);
                    if (actiongram != null) {
                        gor.setActiongram(actiongram);
                        for (GeneralizedActionRequest gar : gor.getGars()) {
                            if (this.xr.isStartElement()) {
                                this.readGar(gar, gor.getId());
                                continue;
                            }
                            this.reportError("02955", productName, gor.getId());
                        }
                        gor.setActiongramLocked(isActiongramLocked);
                        while (this.xr.isStartElement()) {
                            this.checkStartTag("gar");
                            this.reportError("02955", productName, gor.getId());
                            this.skipUntilEndTag();
                            this.skipEndTag("gar");
                        }
                    } else {
                        this.reportError("02960", actiongramName, productName, gor.getId());
                        this.skipUntilEndTag(1);
                    }
                } else if (this.xr.isStartElement()) {
                    this.skipUntilEndTag(1);
                }
            }
            this.skipEndTag("gor");
            return gor;
        }

        private Map<PropertyDefinition, String> readProperties(Class<? extends Propertized> effectivity) throws SuperplanSerializationException, XMLStreamException {
            HashMap<PropertyDefinition, String> res = Maps.newHashMap();
            Collection<PropertyDefinition> propdefs = this.config.getPropertyDefinitionsFor(effectivity);
            this.checkStartTag("properties");
            this.xr.nextTag();
            while (this.xr.isStartElement()) {
                this.checkStartTag("property");
                this.parseAttributes();
                String name = this.getStringAttribute("name");
                String value = this.getStringAttribute("value");
                PropertyDefinition propdef = null;
                for (PropertyDefinition pd : propdefs) {
                    if (!name.equals(pd.getName())) continue;
                    propdef = pd;
                    break;
                }
                if (propdef != null) {
                    res.put(propdef, value);
                } else {
                    this.reportError("02965", name, effectivity);
                }
                this.xr.nextTag();
                this.skipEndTag("property");
            }
            this.skipEndTag("properties");
            return res;
        }

        private void readGar(GeneralizedActionRequest gar, String orderName) throws XMLStreamException, SuperplanSerializationException {
            this.checkStartTag("gar");
            this.parseAttributes();
            long release = this.getLongAttribute("release");
            long due = this.getLongAttribute("due");
            double qty = this.getDoubleAttribute("qty");
            double completedQty = 0.0;
            if (this.hasAttribute("completed-qty")) {
                completedQty = this.getDoubleAttribute("completed-qty");
            }
            double outOfPlanQty = 0.0;
            if (this.hasAttribute("out-of-plan-qty")) {
                outOfPlanQty = this.getDoubleAttribute("out-of-plan-qty");
            }
            double outOfPlanMat = 0.0;
            if (this.hasAttribute("out-of-plan-mat")) {
                outOfPlanMat = this.getDoubleAttribute("out-of-plan-mat");
            }
            String actionName = this.getStringAttribute("action");
            String localAltName = null;
            if (this.hasAttribute("local-alt")) {
                localAltName = this.getStringAttribute("local-alt");
            }
            boolean laLocked = false;
            if (this.hasAttribute("la-locked")) {
                laLocked = this.getBooleanAttribute("la-locked");
            }
            String description = null;
            if (this.hasAttribute("description")) {
                description = this.getStringAttribute("description");
            }
            boolean blocked = false;
            if (this.hasAttribute("blocked")) {
                blocked = this.getBooleanAttribute("blocked");
            }
            long latestPossibleStart = -9223372036854775708L;
            if (this.hasAttribute("latest-possible-start")) {
                latestPossibleStart = this.getLongAttribute("latest-possible-start");
            }
            if (!gar.getAction().getName().equals(actionName)) {
                this.reportError("02930", actionName, gar.getAction().getProduct().getName(), orderName, gar.getAction().getName());
                this.skipUntilEndTag();
            } else {
                gar.unsafeSetReleaseDate(release);
                gar.unsafeSetDueDate(due);
                gar.unsafeSetRequestedQty(qty);
                gar.unsafeSetOutOfPlanQty(outOfPlanQty);
                gar.setOutOfPlanMat(outOfPlanMat);
                gar.setCompletedQty(completedQty);
                if (description != null) {
                    gar.setDescription(description);
                }
                gar.setBlocked(blocked);
                gar.setLatestPossibleStart(latestPossibleStart);
                boolean skipActivities = false;
                if (localAltName != null) {
                    Action localAlt = gar.getAction().getLocalAlt(localAltName);
                    if (localAlt != null) {
                        gar.setAction(localAlt);
                    } else {
                        this.reportError("02931", gar.getAction().getProduct().getName(), orderName, actionName, localAltName);
                        skipActivities = true;
                        laLocked = false;
                    }
                }
                gar.setActionLocked(laLocked);
                this.xr.nextTag();
                while (!this.xr.isEndElement()) {
                    if (this.xr.getLocalName().equals("activities")) {
                        if (skipActivities) {
                            this.skipUntilEndTag();
                        } else {
                            this.xr.nextTag();
                            while (this.xr.isStartElement()) {
                                this.readGarActivity(gar, orderName);
                            }
                        }
                        this.skipEndTag("activities");
                    }
                    if (!this.xr.getLocalName().equals("properties")) continue;
                    gar.setProperties(this.readProperties(GeneralizedActionRequest.class), this.config.getPropertyDefinitionsInfoFor(GeneralizedActionRequest.class));
                }
            }
            this.skipEndTag("gar");
        }

        private void readGarActivity(GeneralizedActionRequest parentGar, String orderName) throws XMLStreamException, SuperplanSerializationException {
            this.checkStartTag("aa");
            this.parseAttributes();
            this.xr.nextTag();
            this.skipEndTag("aa");
            int aid = this.getIntAttribute("aref");
            ActionActivity aa = this.aaMap.get(aid);
            if (aa == null) {
                this.reportError("02935", parentGar.getAction().getName(), orderName);
                return;
            }
            try {
                aa.setAction(parentGar.getAction());
            }
            catch (IllegalStateException e) {
                this.reportError("02907", new Date(aa.getStart()), aa.getWorkplace().getName(), parentGar.getAction().getRebuildType());
                return;
            }
            if (this.addActivityToPlan(aa) == null) {
                return;
            }
            parentGar.unsafeAddActivity(aa);
        }

        private WorkplaceActivity addActivityToPlan(WorkplaceActivity wpa) throws XMLStreamException, SuperplanSerializationException {
            try {
                this.superplan.getPlan().addActivity(wpa);
                return wpa;
            }
            catch (Exception e) {
                if (wpa instanceof ActionActivity) {
                    Action a = ((ActionActivity)wpa).getAction();
                    if (a instanceof CumulativeAction) {
                        this.reportError("02905", new Date(wpa.getStart()), wpa.getWorkplace().getName(), ((CumulativeAction)a).getCumulationType());
                    } else {
                        this.reportError("02910", new Date(wpa.getStart()), wpa.getWorkplace().getName(), e.getMessage());
                    }
                } else {
                    this.reportError("02915", new Date(wpa.getStart()), wpa.getWorkplace().getName(), e.getMessage());
                }
                return null;
            }
        }

        private void readMaterialRequests() throws XMLStreamException, SuperplanSerializationException {
            if (this.xr.isStartElement() && this.xr.getLocalName().equals("customer-requests")) {
                this.xr.nextTag();
                while (this.xr.isStartElement()) {
                    CustomerRequest creq = this.readCustomerRequest();
                    if (creq == null) continue;
                    try {
                        this.superplan.addCustomerRequest(creq);
                    }
                    catch (IllegalArgumentException e) {
                        log.warn("Skipped reading CR: " + e.getMessage());
                    }
                }
                this.skipEndTag("customer-requests");
            }
            if (this.xr.isStartElement() && this.xr.getLocalName().equals("supply-requests")) {
                this.xr.nextTag();
                while (this.xr.isStartElement()) {
                    SupplyRequest sreq = this.readSuplyRequest();
                    if (sreq == null) continue;
                    try {
                        this.superplan.addSupplyRequest(sreq);
                    }
                    catch (IllegalArgumentException e) {
                        log.warn("Skipped reading SR: " + e.getMessage());
                    }
                }
                this.skipEndTag("supply-requests");
            }
        }

        private CustomerRequest readCustomerRequest() throws XMLStreamException, SuperplanSerializationException {
            CustomerRequest res;
            this.checkStartTag("request");
            this.parseAttributes();
            String id = this.getStringAttribute("rid");
            String matprodS = this.getStringAttribute("material");
            long due = this.getLongAttribute("due");
            double qty = this.getDoubleAttribute("qty");
            int priority = this.getIntAttribute("priority");
            Material matprod = this.config.getMatprod(matprodS);
            if (matprod != null) {
                res = new CustomerRequest(id, matprod, due, qty, priority);
                if (this.hasAttribute("state")) {
                    res.setState(CustomerRequest.State.valueOf(this.getStringAttribute("state")));
                }
                if (this.hasAttribute("qty-offset")) {
                    res.setQtyOffsetOnly(this.getDoubleAttribute("qty-offset"));
                }
                if (this.hasAttribute("time-offset")) {
                    res.setTimeOffsetOnly(this.getLongAttribute("time-offset"));
                }
            } else {
                this.reportError("02925", id);
                res = null;
            }
            this.xr.nextTag();
            if (this.xr.isStartElement()) {
                Map<PropertyDefinition, String> properties = this.readProperties(CustomerRequest.class);
                if (res != null) {
                    res.setProperties(properties, this.config.getPropertyDefinitionsInfoFor(CustomerRequest.class));
                }
            }
            this.skipEndTag("request");
            return res;
        }

        private SupplyRequest readSuplyRequest() throws XMLStreamException, SuperplanSerializationException {
            SupplyRequest res;
            this.checkStartTag("request");
            this.parseAttributes();
            String id = this.getStringAttribute("rid");
            String materialS = this.getStringAttribute("material");
            long due = this.getLongAttribute("due");
            double qty = this.getDoubleAttribute("qty");
            Material material = this.config.getMatprod(materialS);
            if (material != null) {
                res = new SupplyRequest(id, material, due, qty);
                if (this.hasAttribute("state")) {
                    res.setState(SupplyRequest.State.valueOf(this.getStringAttribute("state")));
                }
                if (this.hasAttribute("qty-offset")) {
                    res.setQtyOffsetOnly(this.getDoubleAttribute("qty-offset"));
                }
                if (this.hasAttribute("time-offset")) {
                    res.setTimeOffsetOnly(this.getLongAttribute("time-offset"));
                }
            } else {
                this.reportError("02980", id);
                res = null;
            }
            this.xr.nextTag();
            if (this.xr.isStartElement()) {
                Map<PropertyDefinition, String> properties = this.readProperties(SupplyRequest.class);
                if (res != null) {
                    res.setProperties(properties, this.config.getPropertyDefinitionsInfoFor(SupplyRequest.class));
                }
            }
            this.skipEndTag("request");
            return res;
        }

        private void checkStartTag(String name) throws XMLStreamException {
            this.xr.require(1, null, name);
        }

        private void skipEndTag(String name) throws XMLStreamException {
            this.xr.require(2, null, name);
            this.xr.nextTag();
        }

        private void checkEndTag(String name) throws XMLStreamException {
            this.xr.require(2, null, name);
        }

        private void parseAttributes() {
            this.attributes.clear();
            int cnt = this.xr.getAttributeCount();
            for (int i = 0; i < cnt; ++i) {
                this.attributes.put(this.xr.getAttributeLocalName(i), this.xr.getAttributeValue(i));
            }
        }

        private int getIntAttribute(String localName) throws SuperplanSerializationException {
            String s2 = this.attributes.get(localName);
            if (s2 == null) {
                throw new SuperplanSerializationException("Missing argument " + localName + " at " + this.getLocInfo());
            }
            try {
                return Integer.parseInt(s2);
            }
            catch (Exception e) {
                throw new SuperplanSerializationException("Error reading int argument " + localName + " at " + this.getLocInfo());
            }
        }

        private double getDoubleAttribute(String localName) throws SuperplanSerializationException {
            String s2 = this.attributes.get(localName);
            if (s2 == null) {
                throw new SuperplanSerializationException("Missing argument " + localName + " at " + this.getLocInfo());
            }
            try {
                return Double.parseDouble(s2);
            }
            catch (Exception e) {
                throw new SuperplanSerializationException("Error reading double argument " + localName + " at " + this.getLocInfo());
            }
        }

        private long getLongAttribute(String localName) throws SuperplanSerializationException {
            String s2 = this.attributes.get(localName);
            if (s2 == null) {
                throw new SuperplanSerializationException("Missing argument " + localName + " at " + this.getLocInfo());
            }
            try {
                return Long.parseLong(s2);
            }
            catch (Exception e) {
                throw new SuperplanSerializationException("Error reading long argument " + localName + " at " + this.getLocInfo());
            }
        }

        private String getStringAttribute(String localName) throws SuperplanSerializationException {
            String s2 = this.attributes.get(localName);
            if (s2 == null) {
                throw new SuperplanSerializationException("Missing argument " + localName + " at " + this.getLocInfo());
            }
            return s2;
        }

        private boolean getBooleanAttribute(String localName) throws SuperplanSerializationException {
            String s2 = this.attributes.get(localName);
            if (s2 == null) {
                throw new SuperplanSerializationException("Missing argument " + localName + " at " + this.getLocInfo());
            }
            try {
                return Boolean.parseBoolean(s2);
            }
            catch (Exception e) {
                throw new SuperplanSerializationException("Error reading boolean argument " + localName + " at " + this.getLocInfo());
            }
        }

        private boolean hasAttribute(String localName) {
            return this.attributes.containsKey(localName);
        }

        private String getLocInfo() {
            Location location = this.xr.getLocation();
            String id = location.getSystemId();
            int line = location.getLineNumber();
            int col = location.getColumnNumber();
            return (id == null ? "(unknown file)" : id) + (String)(line != -1 ? SuperplanSerializer.WORKPLACE_NAME_VALUE_SEPARATOR + line + (String)(col != -1 ? SuperplanSerializer.WORKPLACE_NAME_VALUE_SEPARATOR + col : "") : "");
        }

        private void skipUntilEndTag(int n) throws XMLStreamException {
            int level = n;
            while (level >= 0 && this.xr.hasNext()) {
                int type = this.xr.next();
                if (type == 1) {
                    ++level;
                    continue;
                }
                if (type != 2) continue;
                --level;
            }
        }

        private void skipUntilEndTag() throws XMLStreamException {
            this.skipUntilEndTag(0);
        }

        private static class TrsaTarget {
            private static final ImmutableMap<String, TrsaTargetType> TYPE_MAP = ImmutableMap.of("gor", TrsaTargetType.GOR, "cr", TrsaTargetType.CR, "sr", TrsaTargetType.SR);
            final TrsaTargetType type;
            final String id;

            TrsaTarget(String type, String id) {
                this.type = Preconditions.checkNotNull(TYPE_MAP.get(type), "Unknown TrSA type %s", (Object)type);
                this.id = Preconditions.checkNotNull(id, "null TrSA target ID");
            }

            TransactionStoreActivityTarget findTargetIn(Superplan superplan) {
                return this.type.findIn(superplan, this.id);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof TrsaTarget)) {
                    return false;
                }
                TrsaTarget that = (TrsaTarget)o;
                return this.type == that.type && this.id.equals(that.id);
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.type, this.id});
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        private static enum TrsaTargetType {
            GOR{

                @Override
                TransactionStoreActivityTarget findIn(Superplan superplan, String id) {
                    return superplan.getGor(id);
                }
            }
            ,
            CR{

                @Override
                TransactionStoreActivityTarget findIn(Superplan superplan, String id) {
                    return superplan.getCustomerRequest(id);
                }
            }
            ,
            SR{

                @Override
                TransactionStoreActivityTarget findIn(Superplan superplan, String id) {
                    return superplan.getSupplyRequest(id);
                }
            };


            abstract TransactionStoreActivityTarget findIn(Superplan var1, String var2);
        }
    }

    private static enum ReaderErrorMode {
        STRICT,
        DELETE_UNKNOWN;

    }
}

